% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{diagnostics}
\alias{diagnostics}
\title{BAS MCMC diagnostic plot.}
\usage{
diagnostics(obj, type = c("pip", "model"), ...)
}
\arguments{
\item{obj}{an object created by bas.lm or bas.glm}

\item{type}{type of diagnostic plot.  If "pip" the marginal inclusion
probabilities are used, while if "model", plot posterior model probabilities}

\item{...}{additional graphics parameters to be passed to plot}
}
\value{
a plot with of the marginal inclusion probabilities (pip) estimated
by MCMC and renormalized marginal likelihoods times prior probabilities or
model probabilities.
}
\description{
Function to help assess convergence of MCMC sampling for bas ojects.
}
\details{
BAS calculates posterior model probabilites in two ways when method="MCMC".
The first is using the relative Monte Carlo frequencies of sampled models.
The second is to renormalize the marginal likelihood times prior
probabilities over the sampled models.  If the markov chain has converged,
these two quantities should be the same and fall on a 1-1 line.  If not,
running longer may be required.  If the chain has not converged, the Monte
Carlo frequencise may have have less bias, although may exhibit more
variability.
}
\examples{

library(MASS)
data(UScrime)
UScrime[,-2] = log(UScrime[,-2])
crime.ZS =  bas.lm(y ~ .,
                   data=UScrime,
                   prior="ZS-null",
                   modelprior=uniform(),
                   method = "MCMC",
                   MCMC.iter = 1000)   # short run for the example
diagnostics(crime.ZS)

}
\seealso{
Other bas methods: \code{\link{BAS}}, \code{\link{bas.lm}},
  \code{\link{coef.bas}}, \code{\link{confint.coef.bas}},
  \code{\link{confint.pred.bas}}, \code{\link{fitted.bas}},
  \code{\link{force.heredity.bas}},
  \code{\link{image.bas}}, \code{\link{predict.basglm}},
  \code{\link{predict.bas}}, \code{\link{summary.bas}},
  \code{\link{update.bas}}
}
\author{
Merlise Clyde (\email{clyde@stat.duke.edu})
}
