% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM.HODC.R
\name{EM.HODC}
\alias{EM.HODC}
\title{Hierachical ordered density clustering (HODC) Algorithm with input generated by Mclust}
\usage{
EM.HODC(pvalue)
}
\arguments{
\item{pvalue}{a vector of p-values obtained from large scale statistical hypothesis testing}
}
\value{
a list of HODC algorithm returned parameters. 
\describe{
\item{mean}{the mean of each of two clusters}
\item{variance}{the variance of each of two clusters}
\item{pro}{the probability of each of two clusters}
\item{classificaiton}{The classification corresponding to each cluster}
}
}
\description{
Hierachical ordered density clustering (HODC) Algorithm with input generated by Mclust
}
\details{
Without the information of networking, we can have an approximation to the marginal density by DPM model fitting on \strong{r}. Suppose the number of finite mixture normals is equal to L_0+L_1, which means the number of classes we have, we apply HODC algorithm in partitioning the $L_0$ and $L_1$ components into two classes,
For this function, the input is generated by Mclust
}
\examples{
\dontrun{
rstat=c(rnorm(50,mean=1),rnorm(50,mean=2),rnorm(100,mean=4),rnorm(100,mean=8))
pvalue=pnorm(-rstat)
mclustHODC=EM.HODC(pvalue)
}
}
