% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_login.R
\name{create_azure_login}
\alias{create_azure_login}
\alias{get_azure_login}
\alias{delete_azure_login}
\alias{list_azure_logins}
\title{Login to Azure Resource Manager}
\usage{
create_azure_login(tenant = "common", app = .az_cli_app_id,
  password = NULL, username = NULL, certificate = NULL,
  auth_type = NULL, version = 2, host = "https://management.azure.com/",
  aad_host = "https://login.microsoftonline.com/", scopes = ".default",
  config_file = NULL, token = NULL,
  graph_host = "https://graph.microsoft.com/", ...)

get_azure_login(tenant = "common", selection = NULL, refresh = TRUE)

delete_azure_login(tenant = "common", confirm = TRUE)

list_azure_logins()
}
\arguments{
\item{tenant}{The Azure Active Directory tenant for which to obtain a login client. Can be a name ("myaadtenant"), a fully qualified domain name ("myaadtenant.onmicrosoft.com" or "mycompanyname.com"), or a GUID. The default is to login via the "common" tenant, which will infer your actual tenant from your credentials.}

\item{app}{The client/app ID to use to authenticate with Azure Active Directory. The default is to login interactively using the Azure CLI cross-platform app, but you can supply your own app credentials as well.}

\item{password}{If \code{auth_type == "client_credentials"}, the app secret; if \code{auth_type == "resource_owner"}, your account password.}

\item{username}{If \code{auth_type == "resource_owner"}, your username.}

\item{certificate}{If `auth_type == "client_credentials", a certificate to authenticate with. This is a more secure alternative to using an app secret.}

\item{auth_type}{The OAuth authentication method to use, one of "client_credentials", "authorization_code", "device_code" or "resource_owner". If \code{NULL}, this is chosen based on the presence of the \code{username} and \code{password} arguments.}

\item{version}{The Azure Active Directory version to use for authenticating.}

\item{host}{Your ARM host. Defaults to \verb{https://management.azure.com/}. Change this if you are using a government or private cloud.}

\item{aad_host}{Azure Active Directory host for authentication. Defaults to \verb{https://login.microsoftonline.com/}. Change this if you are using a government or private cloud.}

\item{scopes}{The Azure Service Management scopes (permissions) to obtain for this login. Only for \code{version=2}.}

\item{config_file}{Optionally, a JSON file containing any of the arguments listed above. Arguments supplied in this file take priority over those supplied on the command line. You can also use the output from the Azure CLI \verb{az ad sp create-for-rbac} command.}

\item{token}{Optionally, an OAuth 2.0 token, of class \link{AzureToken}. This allows you to reuse the authentication details for an existing session. If supplied, the other arguments above to \code{create_azure_login} will be ignored.}

\item{graph_host}{The Microsoft Graph endpoint. See 'Microsoft Graph integration' below.}

\item{...}{For \code{create_azure_login}, other arguments passed to \code{get_azure_token}.}

\item{selection}{For \code{get_azure_login}, if you have multiple logins for a given tenant, which one to use. This can be a number, or the input MD5 hash of the token used for the login. If not supplied, \code{get_azure_login} will print a menu and ask you to choose a login.}

\item{refresh}{For \code{get_azure_login}, whether to refresh the authentication token on loading the client.}

\item{confirm}{For \code{delete_azure_login}, whether to ask for confirmation before deleting.}
}
\value{
For \code{get_azure_login} and \code{create_azure_login}, an object of class \code{az_rm}, representing the ARM login client. For \code{list_azure_logins}, a (possibly nested) list of such objects.

If the AzureRMR data directory for saving credentials does not exist, \code{get_azure_login} will throw an error.
}
\description{
Login to Azure Resource Manager
}
\details{
\code{create_azure_login} creates a login client to authenticate with Azure Resource Manager (ARM), using the supplied arguments. The Azure Active Directory (AAD) authentication token is obtained using \link{get_azure_token}, which automatically caches and reuses tokens for subsequent sessions. Note that credentials are only cached if you allowed AzureRMR to create a data directory at package startup.

\code{create_azure_login()} without any arguments is roughly equivalent to the Azure CLI command \verb{az login}.

\code{get_azure_login} returns a login client by retrieving previously saved credentials. It searches for saved credentials according to the supplied tenant; if multiple logins are found, it will prompt for you to choose one.

One difference between \code{create_azure_login} and \code{get_azure_login} is the former will delete any previously saved credentials that match the arguments it was given. You can use this to force AzureRMR to remove obsolete tokens that may be lying around.
}
\section{Microsoft Graph integration}{

If the AzureGraph package is installed and the \code{graph_host} argument is not \code{NULL}, \code{create_azure_login} will also create a login client for Microsoft Graph with the same credentials. This is to facilitate working with registered apps and service principals, eg when managing roles and permissions. Some Azure services also require creating service principals as part of creating a resource (eg Azure Kubernetes Service), and keeping the Graph credentials consistent with ARM helps ensure nothing breaks.
}

\section{Linux DSVM note}{

If you are using a Linux \href{https://azure.microsoft.com/en-us/services/virtual-machines/data-science-virtual-machines/}{Data Science Virtual Machine} in Azure, you may have problems running \code{create_azure_login()} (ie, without any arguments). In this case, try \code{create_azure_login(auth_type="device_code")}.
}

\examples{
\dontrun{

# without any arguments, this will create a client using your AAD credentials
az <- create_azure_login()

# retrieve the login in subsequent sessions
az <- get_azure_login()

# this will create a Resource Manager client for the AAD tenant 'myaadtenant.onmicrosoft.com',
# using the client_credentials method
az <- create_azure_login("myaadtenant", app="app_id", password="password")

# you can also login using credentials in a json file
az <- create_azure_login(config_file="~/creds.json")

}
}
\seealso{
\link{az_rm}, \link[AzureAuth:get_azure_token]{AzureAuth::get_azure_token} for more details on authentication methods, \link[AzureGraph:graph_login]{AzureGraph::create_graph_login} for the corresponding function to create a Microsoft Graph login client

\href{https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-group-overview}{Azure Resource Manager overview},
\href{https://docs.microsoft.com/en-us/rest/api/resources/}{REST API reference}

\href{https://docs.microsoft.com/en-us/azure/active-directory/develop/authentication-scenarios}{Authentication in Azure Active Directory}

\href{https://docs.microsoft.com/en-us/cli/azure/?view=azure-cli-latest}{Azure CLI documentation}
}
