% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbac.R
\name{rbac}
\alias{rbac}
\alias{add_role_assignment}
\alias{get_role_assignment}
\alias{remove_role_assignment}
\alias{list_role_assignments}
\alias{get_role_definition}
\alias{list_role_definitions}
\title{Role-based access control (RBAC)}
\description{
Basic methods for RBAC: manage role assignments and retrieve role definitions. These are methods for the \code{az_subscription}, \code{az_resource_group} and \code{az_resource} classes.
}
\section{Usage}{
\preformatted{add_role_assignment(principal, role, scope = NULL)

get_role_assignment(id)

remove_role_assignment(id, confirm = TRUE)

list_role_assignments(filter = "atScope()", as_data_frame = TRUE) 

get_role_definition(id)

list_role_definitions(filter=NULL, as_data_frame = TRUE)
}
}

\section{Arguments}{

\itemize{
\item \code{principal}: For \code{add_role_assignment}, the principal for which to assign a role. This can be a GUID, or an object of class \code{az_user}, \code{az_app} or \code{az_storage_principal} (from the AzureGraph package).
\item \code{role}: For \code{add_role_assignment}, the role to assign the principal. This can be a GUID, a string giving the role name (eg "Contributor"), or an object of class \code{[az_role_definition]}.
\item \code{scope}: For \code{add_role_assignment}, an optional scope for the assignment.
\item \code{id}: A role ID. For \code{get_role_assignment} and \code{remove_role_assignment}, this is a role assignment GUID. For \code{get_role_definition}, this can be a role definition GUID or a role name.
\item \code{confirm}: For \code{remove_role_assignment}, whether to ask for confirmation before removing the role assignment.
\item \code{filter}: For \code{list_role_assignments} and \code{list_role_definitions}, an optional filter condition to limit the returned roles.
\item \code{as_data_frame}: For \code{list_role_assignments} and \code{list_role_definitions}, whether to return a data frame or a list of objects. See 'Value' below.
}
}

\section{Details}{

AzureRMR implements a subset of the full RBAC functionality within Azure Active Directory. You can retrieve role definitions and add and remove role assignments, at the subscription, resource group and resource levels.
}

\section{Value}{

The \code{add_role_assignment} and \code{get_role_assignment} methods return an object of class \code{az_role_assignment}. This is a simple R6 class, with one method: \code{remove} to remove the assignment.

The \code{list_role_assignments} method returns a list of \code{az_role_assignment} objects if the \code{as_data_frame} argument is FALSE. If this is TRUE, it instead returns a data frame containing the most broadly useful fields for each assigned role: the role assignment ID, the principal, and the role name.

The \code{get_role_definition} method returns an object of class \code{az_role_definition}. This is a plain-old-data R6 class (no methods), which can be used as input for creating role assignments (see the examples below).

The \code{list_role_definitions} method returns a list of \code{az_role_definition} if the \code{as_data_frame} argument is FALSE. If this is TRUE, it instead returns a data frame containing the most broadly useful fields for each role definition: the definition ID and role name.
}

\examples{
\dontrun{

az <- get_azure_login("myaadtenant")
sub <- az$get_subscription("subscription_id")
rg <- sub$get_resource_group("rgname")
res <- rg$get_resource(type="provider_type", name="resname")

sub$list_role_definitions()
sub$list_role_assignments()
sub$get_role_definition("Contributor")

# get an app using the AzureGraph package
app <- get_graph_login("myaadtenant")$get_app("app_id")

# subscription level
asn1 <- sub$add_role_assignment(app, "Reader")

# resource group level
asn2 <- rg$add_role_assignment(app, "Contributor")

# resource level
asn3 <- res$add_role_assignment(app, "Owner")

res$remove_role_assignment(asn3$id)
rg$remove_role_assignment(asn2$id)
sub$remove_role_assignment(asn1$id)

}

}
\seealso{
\link{az_rm}, \link{az_role_definition}, \link{az_role_assignment}

\href{https://docs.microsoft.com/en-us/azure/role-based-access-control/overview}{Overview of role-based access control}
}
