% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/consume.R
\name{consumeLists}
\alias{consumeLists}
\title{Use a web service to score data in list format}
\usage{
consumeLists(apiKey, requestUrl, ..., globalParam = setNames(list(),
  character(0)), retryDelay = 0.3)
}
\arguments{
\item{apiKey}{primary access key as a string}

\item{requestUrl}{API URL}

\item{...}{variable number of requests entered as lists in key-value format}

\item{globalParam}{global parameters entered as a list, default value is an empty list}

\item{retryDelay}{the time in seconds to delay before retrying in case of a server error, default value is 0.3 seconds}
}
\value{
returnDataFrame data frame containing results returned from web service call
}
\description{
Score data represented as lists, where each list represents one parameter of the web service
}
\examples{
\dontrun{
add <- function(x,y) { return(x+y) }
newService <- publishWebService("add", "add",
 list("x"="int","y"="int"), list("z"="int"), wsID, authToken)
webserviceDetails <- newService[[1]]
endpoints <- newService[[2]]

response <- consumeLists(endpoints[[1]]$PrimaryKey, endpoints[[1]]$ApiLocation,
 list("x"=1, "y"=2), list("x"=3, "y"=4))
}
}
\seealso{
\code{\link{discoverSchema}} \code{\link{publishWebService}}

Other consumption functions: \code{\link{consumeDataframe}};
  \code{\link{consumeFile}}
}

