% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object_props.R
\name{cert_key_properties}
\alias{cert_key_properties}
\alias{cert_x509_properties}
\alias{cert_issuer_properties}
\alias{cert_expiry_action}
\alias{vault_object_attrs}
\title{Helper functions for key vault objects}
\usage{
cert_key_properties(type = c("RSA", "EC"), hardware = FALSE,
  ec_curve = NULL, rsa_key_size = NULL, key_exportable = TRUE,
  reuse_key = FALSE)

cert_x509_properties(dns_names = character(), emails = character(),
  upns = character(), key_usages = c("digitalSignature",
  "keyEncipherment"), enhanced_key_usages = c("1.3.6.1.5.5.7.3.1",
  "1.3.6.1.5.5.7.3.2"), validity_months = NULL)

cert_issuer_properties(issuer = "self", cert_type = NULL,
  transparent = NULL)

cert_expiry_action(remaining = 0.1, action = c("AutoRenew",
  "EmailContacts"))

vault_object_attrs(enabled = TRUE, expiry_date = NULL,
  activation_date = NULL, recovery_level = NULL)
}
\arguments{
\item{type}{For \code{cert_key_properties}, the type of key to create: RSA or elliptic curve (EC). Note that for keys backing a certificate, only RSA is allowed.}

\item{hardware}{For \code{cert_key_properties}, whether to use a hardware key or software key. The former requires a premium key vault.}

\item{ec_curve}{For an EC key, the type of elliptic curve.}

\item{rsa_key_size}{For an RSA key, the key size, either 2048, 3072 or 4096.}

\item{key_exportable}{For a key used in a certificate, whether it should be exportable.}

\item{reuse_key}{For a key used in a certificate, whether it should be reused when renewing the certificate.}

\item{dns_names, emails, upns}{For \code{cert_x509_properties}, the possible subject alternative names (SANs) for a certificate. These should be character vectors.}

\item{key_usages}{For \code{cert_x509_properties}, a character vector of key usages.}

\item{enhanced_key_usages}{For \code{cert_x509_properties}, a character vector of enhanced key usages (EKUs).}

\item{validity_months}{For \code{cert_x509_properties}, the number of months the certificate should be valid for.}

\item{issuer}{For \code{cert_issuer_properties}, the name of the issuer. Defaults to "self" for a self-signed certificate.}

\item{cert_type}{For \code{cert_issuer_properties}, the type of certificate to issue, eg "OV-SSL", "DV-SSL" or "EV-SSL".}

\item{transparent}{For \code{cert_issuer_properties}, whether the certificate should be transparent.}

\item{remaining}{For \code{cert_expiry_action}, The remaining certificate lifetime at which to take action. If this is a number between 0 and 1, it is interpreted as the percentage of life remaining; otherwise, the number of days remaining. To disable expiry actions, set this to NULL.}

\item{action}{For \code{cert_expiry_action}, what action to take when a certificate is about to expire. Can be either "AutoRenew" or "EmailContacts". Ignored if \code{remaining == NULL}.}

\item{enabled}{For \code{vault_object_attrs}, whether this stored object (key, secret, certificate, storage account) is enabled.}

\item{expiry_date, activation_date}{For \code{vault_object_attrs}, the optional expiry date and activation date of the stored object. Can be any R object that can be coerced to POSIXct format.}

\item{recovery_level}{For \code{vault_object_attrs}, the recovery level for the stored object.}
}
\description{
Helper functions for key vault objects
}
\details{
These are convenience functions for specifying the properties of objects stored in a key vault. They return lists of fields to pass to the REST API.
}
