% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kubernetes_cluster.R
\name{kubernetes_cluster}
\alias{kubernetes_cluster}
\title{Create a new Kubernetes cluster object}
\usage{
kubernetes_cluster(config = NULL)
}
\arguments{
\item{config}{The name of the file containing the configuration details for the cluster. This should be a YAML or JSON file in the standard Kubernetes configuration format. Set this to NULL to use the default \code{~/.kube/config} file.}
}
\value{
An R6 object of class \code{KubernetesCluster}.
}
\description{
Create a new Kubernetes cluster object
}
\details{
Use this function to instantiate a new object of the \code{KubernetesCluster} class, for interacting with a Kubernetes cluster.
}
\examples{
\dontrun{

kubernetes_cluster()
kubernetes_cluster("myconfig.yaml")

}
}
\seealso{
\link{KubernetesCluster} for methods for working with the cluster, \link{call_kubectl}, \link{call_helm}

\link{docker_registry} for the corresponding function to create a Docker registry object
}
