% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mathematicalfunctions.R
\name{calc_rot}
\alias{calc_rot}
\title{A 3x3 rotation matrix constructed by projecting the new axes onto the
original system. Likely results in rotation about all axes.}
\usage{
calc_rot(z_vector, x_vector)
}
\arguments{
\item{z_vector}{a 1x3 vector representing the direction for the desired z
axis of the new frame of reference. Frame of reference: VRP}

\item{x_vector}{a 1x3 vector representing the direction for the desired x
axis of the new frame of reference. Frame of reference: VRP}
}
\value{
a 3x3 matrix representing the rotation matrix that transforms between
VRP frame and object frame
}
\description{
A 3x3 rotation matrix constructed by projecting the new axes onto the
original system. Likely results in rotation about all axes.
}
\examples{
library(AvInertia)
z_vector = c(0,0,1)
x_vector = c(-1,0,0)

# should return matrix [[-1,0,0];[0,-1,0];[0,0,1]]
calc_rot(z_vector, x_vector)

}
\author{
Christina Harvey
}
