% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{Plot.ROC}
\alias{Plot.ROC}
\title{Plot.ROC}
\usage{
Plot.ROC(
  dt = NULL,
  SampleSize = 1e+05,
  XVar = NULL,
  YVar = NULL,
  GroupVar = NULL,
  YVarTrans = "Identity",
  XVarTrans = "Identity",
  FacetRows = 1,
  FacetCols = 1,
  FacetLevels = NULL,
  AggMethod = "mean",
  Height = NULL,
  Width = NULL,
  Title = "ROC Plot",
  ShowLabels = FALSE,
  Title.YAxis = "True Positive Rate",
  Title.XAxis = "1 - False Positive Rate",
  EchartsTheme = "macarons",
  MouseScroll = TRUE,
  TimeLine = FALSE,
  TextColor = "white",
  Debug = FALSE
)
}
\arguments{
\item{dt}{source data.table}

\item{SampleSize}{numeric}

\item{XVar}{X-Axis variable name}

\item{YVar}{Y-Axis variable name}

\item{GroupVar}{Character variable}

\item{YVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{XVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{FacetRows}{Defaults to 1 which causes no faceting to occur vertically. Otherwise, supply a numeric value for the number of output grid rows}

\item{FacetCols}{Defaults to 1 which causes no faceting to occur horizontally. Otherwise, supply a numeric value for the number of output grid columns}

\item{FacetLevels}{Faceting rows x columns is the max number of levels allowed in a grid. If your GroupVar has more you can supply the levels to display.}

\item{AggMethod}{character}

\item{Height}{"400px"}

\item{Width}{"200px"}

\item{Title}{character}

\item{ShowLabels}{character}

\item{Title.YAxis}{character}

\item{Title.XAxis}{character}

\item{EchartsTheme}{"auritus","azul","bee-inspired","blue","caravan","carp","chalk","cool","dark-bold","dark","eduardo", #' "essos","forest","fresh-cut","fruit","gray","green","halloween","helianthus","infographic","inspired", #' "jazz","london","dark","macarons","macarons2","mint","purple-passion","red-velvet","red","roma","royal", #' "sakura","shine","tech-blue","vintage","walden","wef","weforum","westeros","wonderland"}

\item{MouseScroll}{logical, zoom via mouse scroll}

\item{TimeLine}{logical}

\item{TextColor}{character hex}

\item{Debug}{Debugging purposes}
}
\value{
plot
}
\description{
ROC Plot
}
\seealso{
Other Model Evaluation: 
\code{\link{Plot.BinaryMetrics}()},
\code{\link{Plot.Calibration.Box}()},
\code{\link{Plot.Calibration.Line}()},
\code{\link{Plot.ConfusionMatrix}()},
\code{\link{Plot.Gains}()},
\code{\link{Plot.Lift}()},
\code{\link{Plot.PartialDependence.Box}()},
\code{\link{Plot.PartialDependence.HeatMap}()},
\code{\link{Plot.PartialDependence.Line}()},
\code{\link{Plot.Residuals.Histogram}()},
\code{\link{Plot.Residuals.Scatter}()},
\code{\link{Plot.ShapImportance}()},
\code{\link{Plot.VariableImportance}()}
}
\author{
Adrian Antico
}
\concept{Model Evaluation}
