% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INTERNAL_utilities.R
\name{IAM_VnkDelta}
\alias{IAM_VnkDelta}
\title{Compute the value V(n,k), needed to caclulate the eppf of a Finite Dirichlet process when the prior on the component-weigts
of the mixture is a Dirichlet with parameter \code{gamma} (i.e. when unnormailized weights are distributed as Gamma(\eqn{\gamma},1) )
when the number of component are fixed to \code{M^*}, i.e. a Dirac prior assigning mass only to \code{M^*} is assumed.
See Section 9.1.1 of the Paper Argiento de Iorio 2019 for more details.}
\usage{
IAM_VnkDelta(n, Mstar, gamma)
}
\arguments{
\item{n}{The sample size}

\item{Mstar}{The number of component of the mixture}

\item{gamma}{The \code{gamma} parameter of the Dirichlet}
}
\value{
A vector of length n, reporting the values \code{V(n,k)} for \code{k=1,...,n}
}
\description{
There are no default values.
}
\keyword{internal}
