% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnimalAPD.R
\name{APDraw}
\alias{APDraw}
\title{Calculate Raw APD Values}
\usage{
APDraw(focal, contingent, adjust = 1)
}
\arguments{
\item{focal}{Vector of observations in radians of one species/group/individual/etc. for which predictions on another will be made}

\item{contingent}{Vector of observations in radians of a species/group/individual/etc. from which predictions will be made}

\item{adjust}{Smoothing of predicted line; recommended to use default value for observed values and higher value for estimations from circular models; default=1}
}
\value{
Numeric vector of raw APD values, without correction for nested data structure
}
\description{
Calculates raw APD values, uncorrected for hierarchical data structure
}
\examples{
data(wolfexample)
data(boarexample)
APDraw(focal=wolfexample$Radians, contingent=boarexample$Radians)

}
