% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_plot.R
\name{bar_plot}
\alias{bar_plot}
\title{Bar Plots for Categorical Variables}
\usage{
bar_plot(
  data,
  fill = "skyblue",
  color = "black",
  width = 0.7,
  subplot = FALSE,
  nrow = 2,
  margin = 0.1,
  html = FALSE
)
}
\arguments{
\item{data}{The input data frame containing categorical variables.}

\item{fill}{Fill color for the bars (default: "skyblue").}

\item{color}{Border color of the bars (default: "black").}

\item{width}{Width of the bars (default: 0.7).}

\item{subplot}{A logical argument (default: FALSE) indicating whether to create subplots.}

\item{nrow}{Number of rows for subplots (if subplot is TRUE, default: 2).}

\item{margin}{Margin for subplots (if subplot is TRUE, default: 0.1).}

\item{html}{Whether the output should be in HTML format,used when knitting into HTML. Default is FALSE.}
}
\value{
A list of bar plots.
}
\description{
This function generates bar plots for all categorical variables in the input data frame.
Bar plots offer a visual representation of the distribution of categorical variables,
making it easy to understand the frequency of each category. They are particularly
useful for exploring patterns, identifying dominant categories, and comparing the relative
frequencies of different levels within each variable.
}
\examples{
data(iris)
bar_plot(iris)

}
