% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitmapfont.r
\name{rawToAmigaBitmapFontSet}
\alias{rawToAmigaBitmapFontSet}
\title{Coerce raw data into an AmigaBitmapFontSet class object}
\usage{
rawToAmigaBitmapFontSet(x, file, disk = NULL)
}
\arguments{
\item{x}{A \code{vector} of \code{raw} data that needs to be
converted into an \code{\link{AmigaBitmapFontSet}}.}

\item{file}{The \code{raw} version of the \code{\link{AmigaBitmapFontSet}}
does not contain the nested font bitmap images. In order to correctly
construct an \code{\link{AmigaBitmapFontSet}} the file location of the
original *.font file is required in order to read and include the
font bitmap image information. \code{file} should thus be a \code{character}
string specifying the file location of the *.font file.}

\item{disk}{A virtual Commodore Amiga disk from which the \code{file} should be
read. This should be an \code{\link[adfExplorer:amigaDisk-class]{amigaDisk}} object. Using
this argument requires the adfExplorer package.
When set to \code{NULL}, this argument is ignored.}
}
\value{
Returns an \code{\link{AmigaBitmapFontSet}} object.
}
\description{
\code{\link{AmigaBitmapFontSet}} objects are comprehensive representations of binary Amiga
font files (*.font). Use this function to convert \code{raw} data from
such a file to an \link{AmigaBitmapFontSet} object.
}
\details{
This function converts \code{raw} data as stored in *.font
files. The function also needs the file location, in order
to load the nested bitmap images for each font height.
This function is effectively the inverse of \code{\link[AmigaFFH]{as.raw}}.
}
\examples{
\dontrun{
data(font_example)

## First create raw font set data. Note that this raw data
## does not include the nested font bitmap images.
fontset.raw <- as.raw(font_example)

## Therefore it is necesary to have the entire font stored as files:
write.AmigaBitmapFontSet(font_example, tempdir())

font.restored <- rawToAmigaBitmapFontSet(fontset.raw, file.path(tempdir(), "AmigaFFH.font"))
}
}
\seealso{
Other AmigaBitmapFont.operations: 
\code{\link{AmigaBitmapFont}},
\code{\link{availableFontSizes}()},
\code{\link{c}()},
\code{\link{fontName}()},
\code{\link{font_example}},
\code{\link{getAmigaBitmapFont}()},
\code{\link{rasterToAmigaBitmapFont}()},
\code{\link{rawToAmigaBitmapFont}()},
\code{\link{read.AmigaBitmapFontSet}()},
\code{\link{read.AmigaBitmapFont}()},
\code{\link{write.AmigaBitmapFont}()}

Other raw.operations: 
\code{\link{as.AmigaBasic}()},
\code{\link{as.raw.AmigaBasic}()},
\code{\link{colourToAmigaRaw}()},
\code{\link{packBitmap}()},
\code{\link{rawToAmigaBasicBMAP}()},
\code{\link{rawToAmigaBasicShape}()},
\code{\link{rawToAmigaBasic}()},
\code{\link{rawToAmigaBitmapFont}()},
\code{\link{rawToAmigaIcon}()},
\code{\link{rawToHWSprite}()},
\code{\link{rawToIFFChunk}()},
\code{\link{rawToSysConfig}()},
\code{\link{simpleAmigaIcon}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBitmapFont.operations}
\concept{raw.operations}
