% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_support.r
\name{dither}
\alias{dither}
\alias{dither}
\alias{dither.raster}
\alias{dither}
\alias{dither.matrix}
\title{Image dithering}
\usage{
dither(x, method, ...)

\method{dither}{raster}(x, method = c("none", "floyd-steinberg", "JJN",
  "stucki", "atkinson", "burkse", "sierra", "two-row-sierra", "sierra-lite"),
  palette, mode = c("none", "HAM6", "HAM8"), ...)

\method{dither}{matrix}(x, method = c("none", "floyd-steinberg", "JJN",
  "stucki", "atkinson", "burkse", "sierra", "two-row-sierra", "sierra-lite"),
  palette, mode = c("none", "HAM6", "HAM8"), ...)
}
\arguments{
\item{x}{Original image data that needs to be dithered. Should be a raster object
(\code{\link[grDevices]{as.raster}}), or a matrix of \code{character} string
representing colours.}

\item{method}{A \code{character} string indicating which dithering method should
be applied. See usage section for all possible options (Note that the "JJN" is
the Jarvis, Judice, and Ninke algorithm). Default is "\code{none}", meaning that
no dithering is applied.}

\item{...}{Currently ignored.}

\item{palette}{A palette to which the image should be dithered. It should be a
\code{vector} of \code{character} strings representing colours.}

\item{mode}{A \code{character} string indicating whether a special
Amiga display mode should be used when dithering. By default
\sQuote{\code{none}} is used (no special mode). In addition,
\sQuote{\code{HAM6}} and \sQuote{\code{HAM8}} are supported.
See \code{\link{rasterToBitmap}} for more details.}
}
\value{
Returns a \code{matrix} with the same dimensions as \code{x} containing
\code{numeric} index values. The corresponding palette is returned as attribute,
as well as the index value for the fully transparent colour in the palette.
}
\description{
Dither is an intentional form of noise applied to an image to avoid colour
banding when reducing the amount of colours in that image. This function
applies dithering to a grDevices \code{raster} image.
}
\details{
The approaches implemented here all use error diffusion to achieve dithering.
Each pixel is scanned (from top to bottom, from left to right), where the actual
colour is sampled and compared with the closest matching colour in the palette.
The error (the differences between the actual and used colour) is distributed over
the surrounding pixels. The only difference between the methods implemented here
is the way the error is distributed. The algorithm itself is identical. For more
details consult the listed references.

Which method results in the best quality image will depend on the original image
and the palette colours used for dithering, but is also a matter of taste. Note
that the dithering algorithm is relatively slow and is provided in this package
for your convenience. As it is not in the main scope of this package you should
use dedicated software for faster/better results.
}
\examples{
\dontrun{
## first: Let's make a raster out of the 'volcano' data, which we can use in the example:
volcano.raster <- as.raster(t(matrix(terrain.colors(1 + diff(range(volcano)))[volcano -
  min(volcano) + 1], nrow(volcano))))

## let's dither the image, using a predefined two colour palette:
volcano.dither <- dither(volcano.raster,
                         method = "floyd-steinberg",
                         palette = c("yellow", "green"))

## Convert the indices back into a raster object, such that we can plot it:
volcano.dither <- as.raster(apply(volcano.dither, 2, function(x) c("yellow", "green")[x]))
par(mfcol = c(1, 2))
plot(volcano.raster, interpolate = F)
plot(volcano.dither, interpolate = F)

## results will get better when a better matching colour palette is used.
## for that purpose use the function 'index.colours'.
}
}
\references{
R.W. Floyd, L. Steinberg, \emph{An adaptive algorithm for spatial grey scale}. Proceedings of the Society of Information Display 17, 75-77 (1976).

J. F. Jarvis, C. N. Judice, and W. H. Ninke, \emph{A survey of techniques for the display of continuous tone pictures on bilevel displays}. Computer Graphics and Image Processing, 5:1:13-40 (1976).

\url{https://en.wikipedia.org/wiki/Floyd-Steinberg_dithering}

\url{http://www.tannerhelland.com/4660/dithering-eleven-algorithms-source-code/}
}
\seealso{
Other colour.quantisation.operations: \code{\link{index.colours}}

Other raster.operations: \code{\link{AmigaBitmapFont}},
  \code{\link{as.raster}}, \code{\link{bitmapToRaster}},
  \code{\link{index.colours}},
  \code{\link{rasterToAmigaBitmapFont}},
  \code{\link{rasterToBitmap}},
  \code{\link{rasterToHWSprite}}, \code{\link{rasterToIFF}}
}
\author{
Pepijn de Vries
}
