% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pullGeno.R
\name{getQtlMap}
\alias{getQtlMap}
\title{Get QTL genetic map}
\usage{
getQtlMap(trait = 1, sex = "A", simParam = NULL)
}
\arguments{
\item{trait}{an integer for the}

\item{sex}{determines which sex specific map 
is returned. Options are "A" for average map, "F" 
for female map, and "M" for male map. All options are 
equivalent if not using sex specific maps.}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns a data.frame with:
\describe{
  \item{id}{Unique identifier for the QTL}
  \item{chr}{Chromosome containing the QTL}
  \item{site}{Segregating site on the chromosome}
  \item{pos}{Genetic map position}
}
}
\description{
Retrieves the genetic map for the 
QTL of a given trait.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(5)

#Pull SNP map
getQtlMap(trait=1, simParam=SP)

}
