% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importData.R
\name{importInbredGeno}
\alias{importInbredGeno}
\title{Import inbred, diploid genotypes}
\usage{
importInbredGeno(geno, genMap, ped = NULL)
}
\arguments{
\item{geno}{a matrix of genotypes}

\item{genMap}{genetic map as a data.frame. The first
three columns must be: marker name, chromosome, and 
map position (Morgans). Marker name and chromosome are 
coerced using as.character. See \link{importGenMap}}

\item{ped}{an optional pedigree for the supplied 
genotypes. The first three columns must be: id, 
mother, and father. All values are coerced using 
as.character.}
}
\value{
a \code{\link{MapPop-class}} if ped is NULL,
otherwise a \code{\link{NamedMapPop-class}}
}
\description{
Formats the genotypes from inbred, diploid lines 
to an AlphaSimR population that can be used to 
initialize a simulation. An attempt is made to 
automatically detect 0,1,2 or -1,0,1 genotype coding. 
Heterozygotes or probabilistic genotypes are allowed, 
but will be coerced to the nearest homozygote. Pedigree 
information is optional and when provided will be 
passed to the population for easier identification 
in the simulation.
}
\examples{
geno = rbind(c(2,2,0,2,0),
             c(0,2,2,0,0))
colnames(geno) = letters[1:5]

genMap = data.frame(markerName=letters[1:5],
                    chromosome=c(1,1,1,2,2),
                    position=c(0,0.5,1,0.15,0.4))

ped = data.frame(id=c("a","b"),
                 mother=c(0,0),
                 father=c(0,0))

founderPop = importInbredGeno(geno=geno,
                              genMap=genMap,
                              ped=ped)

}
