% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pullGeno.R
\name{pullIbdHaplo}
\alias{pullIbdHaplo}
\title{Pull IBD haplotypes}
\usage{
pullIbdHaplo(pop, chr = NULL, simParam = NULL)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{chr}{a vector of chromosomes to retrieve. If NULL,
all chromosome are retrieved.}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns a matrix of SNP haplotypes.
}
\description{
Retrieves IBD haplotype data
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=15)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)
SP$addSnpChip(5)
SP$setTrackRec(TRUE)

#Create population
pop = newPop(founderPop, simParam=SP)
pullIbdHaplo(pop, simParam=SP)

}
