% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenotypes.R
\name{setPheno}
\alias{setPheno}
\title{Set phenotypes}
\usage{
setPheno(
  pop,
  varE = NULL,
  reps = 1,
  fixEff = 1L,
  p = NULL,
  onlyPheno = FALSE,
  simParam = NULL
)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}} or 
\code{\link{HybridPop-class}}}

\item{varE}{error variances for phenotype. A vector of length 
nTraits for independent error or a square matrix of dimensions 
nTraits for correlated errors. If NULL, value in simParam is used.}

\item{reps}{number of replications for phenotype. See details.}

\item{fixEff}{fixed effect to assign to the population. Used 
by genomic selection models only.}

\item{p}{the p-value for the environmental covariate 
used by GxE traits. If NULL, a value is
sampled at random.}

\item{onlyPheno}{should only the phenotype be returned, see return}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns an object of \code{\link{Pop-class}} or 
\code{\link{HybridPop-class}} if onlyPheno=FALSE, if 
onlyPheno=TRUE a matrix is returned
}
\description{
Sets phenotypes for all traits by adding random error 
from a multivariate normal distribution.
}
\details{
The reps parameter is for convient representation of replicated data. 
It is intended to represent replicated yield trials in plant 
breeding programs. In this case, varE is set to the plot error and 
reps is set to the number of plots per entry. The resulting phenotype 
represents entry means.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)

#Create population
pop = newPop(founderPop, simParam=SP)

#Add phenotype with error variance of 1
pop = setPheno(pop, varE=1)

}
