% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection.R
\name{selectOP}
\alias{selectOP}
\title{Select open pollinating plants}
\usage{
selectOP(pop, nInd, nSeeds, probSelf = 0, pollenControl = FALSE,
  trait = 1, use = "pheno", selectTop = TRUE, candidates = NULL,
  simParam = NULL, ...)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{nInd}{the number of plants to select}

\item{nSeeds}{number of seeds per plant}

\item{probSelf}{percentage of seeds expected from selfing. 
Value ranges from 0 to 1.}

\item{pollenControl}{are plants selected before pollination}

\item{trait}{the trait for selection. Either a number indicating 
a single trait or a function returning a vector of length nInd.}

\item{use}{select on genetic values "gv", estimated
breeding values "ebv", breeding values "bv", phenotypes "pheno", 
or randomly "rand"}

\item{selectTop}{selects highest values if true. 
Selects lowest values if false.}

\item{candidates}{an optional vector of eligible selection candidates.}

\item{simParam}{an object of \code{\link{SimParam}}}

\item{...}{additional arguments if using a function for 
trait}
}
\value{
Returns an object of \code{\link{Pop-class}}
}
\description{
This function models selection in an open pollinating 
plant population. It allows for varying the percentage of 
selfing. The function also provides an option for modeling 
selection as occuring before or after pollination.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)
SP$setVarE(h2=0.5)

#Create population
pop = newPop(founderPop, simParam=SP)

#Create new population by selecting the best 3 plant
#Assuming 50\% selfing in plants and 10 seeds per plant
pop2 = selectOP(pop, nInd=3, nSeeds=10, probSelf=0.5, simParam=SP)

}
