% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-paSynoptic.R
\name{pas_hasSpatial}
\alias{pas_hasSpatial}
\title{Test for spatial metadata in \emph{pa_synoptic} object}
\usage{
pas_hasSpatial(pas)
}
\arguments{
\item{pas}{A \emph{pa_synoptic} object.}
}
\value{
\code{TRUE} if \code{pas} contains core spatial metadata, 
\code{FALSE} otherwise.
}
\description{
Tests for the existence of the following core spatial metadata 
columns:

\itemize{
  \item{longitude -- decimal degrees E}
  \item{latitude -- decimal degrees N}
  \item{timezone -- Olson timezone}
  \item{countryCode -- ISO 3166-1 alpha-2}
  \item{stateCode -- ISO 3166-2 alpha-2}
}

If these columns are missing, they can be added by with
\code{\link{pas_addSpatialMetadata}}.
}
\examples{
pas <- example_pas
pas_hasSpatial(pas)
}
