% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian_analysis.R
\name{gaussianreg}
\alias{gaussianreg}
\title{Analysis: Analogous to the Gaussian model/Bragg}
\usage{
gaussianreg(
  trat,
  resp,
  npar = "g3",
  sample.curve = 1000,
  ylab = "Dependent",
  xlab = "Independent",
  theme = theme_classic(),
  error = "SE",
  legend.position = "top",
  r2 = "all",
  point = "all",
  width.bar = NA,
  scale = "none",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  pointshape = 21,
  fillshape = "gray",
  colorline = "black",
  round = NA,
  xname.formula = "x",
  yname.formula = "y",
  comment = NA,
  fontfamily = "sans"
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{npar}{number of parameters (g3 or g4)}

\item{sample.curve}{Provide the number of observations to simulate curvature (default is 1000)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{legend.position}{legend position (\emph{default} is "top")}

\item{r2}{coefficient of determination of the mean or all values (\emph{default} is all)}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}

\item{textsize}{Font size}

\item{pointsize}{shape size}

\item{linesize}{line size}

\item{pointshape}{format point (default is 21)}

\item{fillshape}{Fill shape}

\item{colorline}{Color lines}

\item{round}{round equation}

\item{xname.formula}{Name of x in the equation}

\item{yname.formula}{Name of y in the equation}

\item{comment}{Add text after equation}

\item{fontfamily}{Font family}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
Analysis: Analogous to the Gaussian model/Bragg
}
\details{
The model analogous to the three-parameter Gaussian is:
\deqn{y = d \times e^{-b((x-e)^2)}}
The model analogous to the three-parameter Gaussian is:
\deqn{y = d \times c+(d-c)*e^{-b((x-e)^2)}}
}
\examples{
library(AgroReg)
data("aristolochia")
attach(aristolochia)
gaussianreg(trat,resp)
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
