% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Aggregate.R
\name{Aggregate}
\alias{Aggregate}
\title{Aggregate numeric and categorical variables by an ID}
\usage{
Aggregate(x, by, ...)
}
\arguments{
\item{x}{A data frame without the ID. Categorical variables have to be of type character or factor and continuous variables have to be of type integer or numeric.}

\item{by}{A vector containing IDs.}

\item{...}{Extra parameters to be passed to the \code{dummy} function in the \code{dummy} package.}
}
\value{
A data frame with the aforementioned variables aggregated by the given ID variables
}
\description{
The \code{Aggregate} function (not to be confounded with aggregate) prepares a data frame for merging by computing the sum, mean and variance of all continuous (integer and numeric) variables by a given ID variable. It also creates dummies for all categorical variables (character and factor) and subsequently computes the sum by a given ID variable. This functions aims at maximum information extraction with a minimum amount of code.
}
\examples{
# Example
# Create some data
data <- data.frame(V1=as.factor(c('yes','no','no','yes','yes','yes','yes')),
                   V2=as.character(c(1,2,3,4,4,4,4)),V3=c(1:7),V4=as.numeric(c(7:1)))
ID=as.character(c(1,1,1,1,2,2,2))
Aggregate(x=data,by=ID)

# Examples of how to use the ... argument. See package dummy for details.
# library(dummmy)
# Aggregate(x=data,by=ID,object=categories(data))
# Aggregate(x=data,by=ID,p=2)
}
\author{
Authors: Matthias Bogaert, Michel Ballings, Dirk Van den Poel, Maintainer: \email{matthias.bogaert@UGent.be}
}

