% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iplot_years.R
\name{iplot_years}
\alias{iplot_years}
\title{Interactive Plotting Pollen Data (one pollen type).}
\usage{
iplot_years(data, pollen)
}
\arguments{
\item{data}{A \code{data.frame} object. This \code{data.frame} should include a first column in format \code{Date} and the rest of columns in format \code{numeric} belonging to each pollen type by column.}

\item{pollen}{A \code{character} string with the name of the particle to show. This \code{character} must match with the name of a column in the input database. This is a mandatory argument.}
}
\value{
An interactive plot of the class \pkg{ggvis}.
}
\description{
Function to plot the pollen data of a pollen type during several seasons. The plots are fully interactive.
}
\examples{
data("munich")
iplot_years(data = munich, pollen = "Betula")
}
\seealso{
\code{\link{iplot_pollen}}
}
