\name{paretoRadiusForGMM}
\alias{paretoRadiusForGMM}

\title{ParetoRadius for GMM}
\description{
  Calculation of the ParetoRadius i.e. the 18 percentiles of all mutual Euclidian distances in data.
}
\usage{
paretoRadiusForGMM(Data,maximumNrSamples,plotDistancePercentiles)
}
\arguments{
  \item{Data}{numeric data vector}
  \item{maximumNrSamples}{Optional, numeric. Maximum number for which the distance calculation can be done. 1000 by default.}
  \item{plotDistancePercentiles}{Optional, logical. If TRUE,  a plot of the percentiles of distances is produced. FALSE by default.}
}

\value{
  numeric value, the Pareto radius.
}
\details{The Pareto-radius of the hyperspheres is derived from the optimization of information for minimal set size.}
\note{
  paretoRadiusForGMM() is a kernel density estimation for variable intervals.
}
\references{Ultsch, A.: Pareto density estimation: A density estimation for knowledge discover, in  Baier, D.; Werrnecke, K. D., (Eds), Innovations in classification, data science, and information systems, Proc Gfkl 2003, pp 91-100, Springer, Berlin, 2005.}
\author{Michael Thrun}
\seealso{\code{\link{paretoDensityEstimationForGMM}}, \code{\link{OptimalNoBins}}}
\keyword{kernel density estimation}