% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportToJson.R
\name{exportPersonToJson}
\alias{exportPersonToJson}
\title{exportPersonToJson}
\usage{
exportPersonToJson(
  connectionDetails,
  cdmDatabaseSchema,
  resultsDatabaseSchema,
  outputPath,
  vocabDatabaseSchema = cdmDatabaseSchema
)
}
\arguments{
\item{connectionDetails}{An R object of type ConnectionDetail (details for the function that
contains server info, database type, optionally username/password,
port)}

\item{cdmDatabaseSchema}{Name of the database schema that contains the vocabulary files}

\item{resultsDatabaseSchema}{of the database schema that contains the Achilles analysis files.
Default is cdmDatabaseSchema}

\item{outputPath}{folder location to save the JSON files. Default is current working
folder}

\item{vocabDatabaseSchema}{name of database schema that contains OMOP Vocabulary. Default is
cdmDatabaseSchema. On SQL Server, this should specifiy both the
database and the schema, so for example 'results.dbo'.}
}
\value{
none
}
\description{
\code{exportPersonToJson} Exports Achilles Person report into a JSON form for reports.
}
\details{
Creates individual files for Person report found in Achilles.Web
}
\examples{
\dontrun{
connectionDetails <- DatabaseConnector::createConnectionDetails(dbms = "sql server",
                                                                server = "yourserver")
exportPersonToJson(connectionDetails,
                   cdmDatabaseSchema = "cdm4_sim",
                   outputPath = "your/output/path")
}
}
