% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_colour_layer.R
\name{scale_colour_academic_d}
\alias{scale_colour_academic_d}
\title{Scale Plot Colours With Academic Themes (Discrete)}
\usage{
scale_colour_academic_d(palette_name, ...)
}
\arguments{
\item{palette_name}{The name of a colour palette in \code{AcademicThemes}.}

\item{...}{Arguments passed to \code{ggplot2::discrete_scale()}.}
}
\value{
A layer that can be added to a ggplot2 object.
}
\description{
Scale Plot Colours With Academic Themes (Discrete)
}
\examples{
library(ggplot2)
ggplot(
  data.frame(
    x = runif(1500),
    y = runif(1500),
    c = sample(LETTERS[1:3], 1500, replace = TRUE)
  ),
  aes(x = x, y = y, colour = c)
) +
  geom_point() +
  scale_colour_academic_d("cruk") +
  theme_classic() +
  labs(
    x = "X-Axis",
    y = "Y-Axis",
    colour = "Colour"
  )
}
