% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aster_temp.R
\name{aster_temp}
\alias{aster_temp}
\title{ASTER Thermal bands to temperature}
\usage{
aster_temp(directory = getwd(), crop = "n", ext2crop = "none")
}
\arguments{
\item{directory}{Path to ASTER hdf file/ files folder. Assign as string (inside double quotes).
Either provide the path inside function or set up satellite image folder as the current working directory
before running the function.
To define current working directory, either use shortcut key Ctrl+Shift+H  or use \code{\link{setwd}} funtion.}

\item{ext2crop, crop}{Same as mentioned in \code{\link[ASIP]{arvi}}.}
}
\value{
Radiance, at-satellite brightness temperature and land surface temperature (optional) of multiple hdf files in a folder named "output_bands" in the input directory.
}
\description{
Converts thermal bands of multiple ASTER L1T hdf files to Radiance and At-sensor brightness temperature.
}
\note{
1. Windows users users should be careful while assigning directory. Use "/" to seperate folders not "\\".

2. The base of this function is provided by Land processes distributed active archive center (LP DAAC).
Raw code is customized to produce this function with additional functionalities and more ease of use. Authors are thankful to LP DAAC, NASA and USGS.
}
\references{
\href{http://www.sciencedirect.com/science/article/pii/S0034425703003390}{Q. Weng, D. Lu, and J. Schubring, “Estimation of land surface temperature–vegetation abundance relationship for urban heat island studies,” Remote Sens. Environ., vol. 89, no. 4, pp. 467–483, 2004. doi:10.1016/j.rse.2003.11.005}
}
