% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{HigginsABC}
\alias{HigginsABC}
\title{Synthetic 2x2x2 Mixed Design Experiment}
\format{A data frame with 16 observations on the following 5 variables.
\describe{ 
     \item{Subject}{a factor with levels \code{"s1"} .. \code{"s8"}} 
     \item{A}{a factor with levels \code{"a1"} \code{"a2"}} 
     \item{B}{a factor with levels \code{"b1"} \code{"b2"}} 
     \item{C}{a factor with levels \code{"c1"} \code{"c2"}}
     \item{Y}{a numeric vector} 
}}
\source{
Wobbrock, J. O., Findlater, L., Gergle, D., and Higgins, J. J.
\emph{ARTool}. \url{http://depts.washington.edu/aimgroup/proj/art/}.
}
\description{
Synthetic data from an experiment with two between-\code{Subject}s factors
(\code{A} and \code{B}) having two levels each and one
within-\code{Subject}s factor (\code{C}) with two levels.
}
\examples{
\dontrun{
data(HigginsABC, HigginsABC.art, package="ARTool")

## run aligned-rank transform and ANOVA on the data
m <- art(Y ~ A*B*C + Error(Subject), data=HigginsABC)
anova(m)
}
}
\seealso{
\code{\link{art}}, \code{\link{anova.art}}.
}
\keyword{datasets}
