% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{plot.behavior_stream}
\alias{plot.behavior_stream}
\title{Plot method for \code{behavior_stream} objects}
\usage{
\method{plot}{behavior_stream}(x, session_color = "black",
  episode_color = "blue", episode_thickness = 2, ...)
}
\arguments{
\item{x}{object of class \code{behavior_stream}}

\item{session_color}{character string indicating the color of the lines that
represent session time. Default is black.}

\item{episode_color}{character string indicating the color of the bars that
represent episode durations. Default is blue.}

\item{episode_thickness}{numeric value indicating the thickness of the bars
that represent episode durations. Default is 2.}

\item{...}{Further arguments, not used for this method.}
}
\value{
An object of class \code{ggplot}.
}
\description{
Creates a graphical representation of a set of simulated 
  behavior streams.
}
\details{
The plot is created using \code{ggplot} from the ggplot2 package, 
  which must be installed.
}
\examples{
b_streams <- r_behavior_stream(n = 5, mu = 3, lambda = 10, 
                               F_event = F_exp(), F_interim = F_exp(), 
                               stream_length = 100)
plot(b_streams)
}
