% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_density.R
\name{plot_density_metric}
\alias{plot_density_metric}
\title{Internal helper to plot a metric density}
\usage{
plot_density_metric(
  dat,
  y_var,
  plot_type = "density",
  dat_highlightDiagonals = NULL,
  y_var_cat_breaks = NULL,
  y_var_cat_labels = NULL,
  weights_var = NULL,
  log_scale = FALSE,
  xlab = NULL,
  ylab = NULL,
  legend_title = NULL,
  ...
)
}
\arguments{
\item{dat}{Dataset with columns \code{period} and \code{age} and the
main variable specified through argument \code{y_var}.}

\item{y_var}{Character name of the main variable to be plotted.}

\item{plot_type}{One of \code{c("density","boxplot")}. Only used if the
\code{y_var} column is metric.}

\item{dat_highlightDiagonals}{Optional dataset created by
\code{\link{create_highlightDiagonalData}} to highlight specific diagonals
in a density matrix.}

\item{y_var_cat_breaks}{Optional numeric vector of breaks to categorize
\code{y_var} based on calling function \code{\link{cut}}. Only used to
highlight the categories based on different colors. And only used if the
\code{y_var} column is numeric.}

\item{y_var_cat_labels}{Optional character vector for the names of the
categories that were defined based on \code{y_var_cat_breaks}. The length of
this vector must be one shorter than \code{length(y_var_cat_breaks)}. Only
used if the \code{y_var} column is numeric.}

\item{weights_var}{Optional character name of a weights variable used to
project the results in the sample to some population.}

\item{log_scale}{Indicator if the main variable should be log10 transformed.
Only used if the \code{y_var} column is numeric. Defaults to FALSE.}

\item{xlab, ylab, legend_title}{Optional plot annotations.}

\item{...}{Additional arguments passed to \code{\link[stats]{density}}.}
}
\description{
Internal helper function to plot one metric density, to be called from within
\code{\link{plot_density}}.
}
