% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state_diversity_counts.R
\name{get_apc_genus_family_lookup}
\alias{get_apc_genus_family_lookup}
\title{Lookup Family by Genus from APC}
\usage{
get_apc_genus_family_lookup(genus, resources = load_taxonomic_resources())
}
\arguments{
\item{genus}{A character vector of genus names for which to retrieve the
corresponding family names.}

\item{resources}{The taxonomic resources required to make the lookup.
Loading this can be slow, so call \code{\link{load_taxonomic_resources}}
separately to speed up this function and pass the resources in.}
}
\value{
A data frame with two columns: "genus", indicating the genus name,
and "family", indicating the corresponding family name from the APC.
}
\description{
Retrieve the family name for a given genus using taxonomic data from the
Australian Plant Census (APC).
}
\examples{
 \donttest{get_apc_genus_family_lookup(genus = c("Acacia", "Eucalyptus"))}
}
\seealso{
\code{\link{load_taxonomic_resources}}
}
