% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.diameter.R
\name{met.diameter}
\alias{met.diameter}
\title{Diameter}
\usage{
met.diameter(
  M,
  df = NULL,
  weighted = TRUE,
  shortest.weight = FALSE,
  normalization = TRUE,
  directed = TRUE,
  out = TRUE
)
}
\arguments{
\item{M}{a square adjacency matrix, or a list of square adjacency matrices, or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{df}{a data frame of same length as the input matrix or a list of data frames if argument \emph{M} is a list of matrices or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{weighted}{if \emph{FALSE}, it binarizes the square adjacency matrix M. Geodesic distances and diameter are based only on the presence or absence of edges.}

\item{shortest.weight}{if \emph{false}, it considers the highest met.strength as the shortest path.}

\item{normalization}{normalizes the weights of the links i.e. divides them by the average strength of the network. Argument normalization can't be TRUE when argument weighted is FALSE.}

\item{directed}{if \emph{false}, then it symmetrizes the matrix. Otherwise, it calculates geodesic distances and diameter according to the directionality of the links.}

\item{out}{if \emph{true}, it considers outgoing ties.}
}
\value{
\itemize{
\item a double representing the diameter of the network if argument \emph{M} is a square matrix.
\item A list of doubles if argument \emph{M} is a list of matrices and if argument \emph{df} is \emph{NULL}. Each double represents the diameter of the corresponding matrix of the list.
\item A list of arguments \emph{df} with a new column of network diameter if argument\emph{df} is not \emph{NULL} and if argument \emph{M} is a list of matrices. The name of the column is adapted according to arguments values \emph{.weighted}, \emph{shortest.weight}, \emph{normalization}, \emph{directed} and \emph{out}.
\item A list of arguments \emph{df} with a new column of network diameter if argument \emph{df} is not \emph{NULL}, if argument \emph{M} is an output from ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk} for multiple matrices permutations, and if argument \emph{df} is a list of data frames of same length as argument \emph{M}.
}
}
\description{
Calculates the network diameter .
}
\details{
Diameter is the longer geodesic distance.
}
\examples{
met.diameter(sim.m)
}
\references{
Opsahl, T., Agneessens, F., & Skvoretz, J. (2010). Node centrality in weighted networks: Generalizing degree and shortest paths. Social networks, 32(3), 245-251.

Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
