% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.glm.R
\name{stat.glm}
\alias{stat.glm}
\title{Permuted Generalized Linear Model}
\usage{
stat.glm(
  ant,
  oda,
  formula,
  family = "gaussian",
  progress = TRUE,
  start = NULL,
  control = list(...),
  model = TRUE,
  method = "glm.fit",
  x = FALSE,
  y = TRUE,
  contrasts = NULL,
  ...
)
}
\arguments{
\item{ant}{an output of ANT function \code{\link{perm.net.nl}} without any random factor declared, or output of ANT 'met' category functions in which output of ANT functions \code{\link{perm.ds.focal}}, \code{\link{perm.ds.grp}} or \code{\link{perm.net.lk}} where single matrices were used.}

\item{oda}{the original data frame of associations when argument ant is obtained with \code{\link{perm.ds.focal}} or \code{\link{perm.ds.grp}} ANT functions.}

\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted. The details of model specification are given under 'Details'.}

\item{family}{a description of the error distribution and link function to be used in the model. For glm this can be a character string naming a family function, a family function or the result of a call to a family function. For glm.fit only the third option is supported, see \code{\link[stats]{glm}} and \code{\link[stats]{family}}.}

\item{progress}{a boolean indicating the visualization of the permutation process.}

\item{start}{starting values for the parameters in the linear predictor.}

\item{control}{a list of parameters for controlling the fitting process.}

\item{model}{a logical value indicating whether model frame should be included as a component of the returned value.}

\item{method}{the method to be used in fitting the model. The default method "glm.fit" uses iteratively reweighted least squares (IWLS): the alternative "model.frame" returns the model frame and does no fitting.}

\item{x, y}{For glm: logical values indicating whether the response vector and model matrix used in the fitting process should be returned as components of the returned value.}

\item{contrasts}{an optional list. See the contrasts.arg of model.matrix.default.}

\item{...}{Extra arguments for \code{\link[stats]{glm}} function only.}
}
\value{
Returns a list of 3 elements :
\itemize{
\item An object of class inheriting from "glm" which inherits from the class "lm".
\item A data frame if the estimates of the permuted models.
\item A vector of integers indicating the permutations that returned model errors or warnings (e.g. model convergence issues) and for which new permutations were done.
}
}
\description{
Performs Generalized Linear Models tests and computes permuted p-values
}
\details{
This function is the first step in the process to create a t-test in permuted data. For more details on t-tests, see R documentation.
}
\examples{
t=met.degree(sim.m, sym = TRUE,sim.df,1) # Computing network metric
t=perm.net.nl(t,labels='age',rf=NULL,nperm=10,progress=FALSE) # Node label permutations
r.glm=stat.glm(ant = t,formula = degree ~ sex,progress=FALSE) # Permuted GLM
}
\references{
Dobson, A. J. (1990) An Introduction to Generalized Linear Models. London: Chapman and Hall.

Hastie, T. J. and Pregibon, D. (1992) Generalized linear models. Chapter 6 of Statistical Models in S eds J. M. Chambers and T. J. Hastie, Wadsworth & Brooks/Cole.

McCullagh P. and Nelder, J. A. (1989) Generalized Linear Models. London: Chapman and Hall.

Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics with S. New York: Springer.
}
\seealso{
\code{\link[stats]{glm}}
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
