% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.betweenness.R
\name{met.betweenness}
\alias{met.betweenness}
\title{Betweenness centrality}
\usage{
met.betweenness(
  M,
  binary = FALSE,
  shortest.weight = FALSE,
  normalization = TRUE,
  sym = FALSE,
  out = TRUE,
  df = NULL,
  dfid = NULL
)
}
\arguments{
\item{M}{a square adjacency matrix, or a list of square adjacency matrices, or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{binary}{ia boolean, if \emph{TRUE}, it calculates the binary version of the betweenness centrality.}

\item{shortest.weight}{if \emph{FALSE}, it considers the highest \emph{strength} as the shortest path.}

\item{normalization}{normalizes the weigths of the links i.e. divides them by the average strength of the network. Argument normalization can't be \emph{TRUE} when argument binary is \emph{FALSE}.}

\item{sym}{if \emph{TRUE}, then it symmetrizes the matrix. Otherwise, it calculates geodesic distances and diameter according to the directionality of the links.}

\item{out}{if \emph{TRUE}, it considers outgoing ties to compute shortest paths.}

\item{df}{a data frame of same length as the input matrix or a list of data frames if argument \emph{M} is a list of matrices or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{dfid}{an integer or a string indicating the column with individual ids in argument \emph{df}.}
}
\value{
\itemize{
\item An integer vector of nodes \emph{betweenness} if argument \emph{df} is \emph{NULL}.
\item A list of integer vectors of nodes \emph{betweenness} if argument \emph{M} is a list and if argument \emph{df} is \emph{NULL}.
\item A list of arguments df with a new column for nodes \emph{betweenness} if argument \emph{df} is not \emph{NULL}. The name of the column is adapted according to arguments \emph{binary}, \emph{shortest.weight}, \emph{normalization}, \emph{sym} and \emph{out}.
\item A list of arguments df with a new column for nodes \emph{betweenness} if argument \emph{df} is not \emph{NULL}, if argument \emph{M} is an output from ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk} for multiple matrices permutations, and if argument \emph{df} is a list of data frames of same length as argument \emph{M}.
}
}
\description{
Computes node betweenness centrality of all nodes of the network.
}
\details{
Betweenness is the number of times a node is included in the shortest paths (geodesic distances) between all the potential combinations of edges of the other nodes. As it directly derives from the geodesic distance, it is important to pay attention to how the investigator intends to calculate geodesic distances (binary or weighted, directed or undirected, and using the lowest or the highest strength as the shortest path). Betweenness provides a specific centrality measure insofar that it informs on the role of a node in the transmission of information as nodes with high betweenness are likely to constitute bridges that connect subgroups.
}
\examples{
met.betweenness(sim.m)
head(sim.df)
met.betweenness(sim.m,df=sim.df)
}
\references{
Freeman, L. C. (1978). Centrality in social networks conceptual clarification. Social networks, 1(3), 215-239.

Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Hu Feng He, Sebastian Sosa, Ivan Puga-Gonzalez, Xiaohua Xie.
}
