% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mo_source.R
\name{mo_source}
\alias{mo_source}
\alias{set_mo_source}
\alias{get_mo_source}
\title{User-defined reference data set for microorganisms}
\usage{
set_mo_source(path)

get_mo_source()
}
\arguments{
\item{path}{location of your reference file, see Details. Can be \code{""}, \code{NULL} or \code{FALSE} to delete the reference file.}
}
\description{
These functions can be used to predefine your own reference to be used in \code{\link[=as.mo]{as.mo()}} and consequently all \verb{mo_*} functions like \code{\link[=mo_genus]{mo_genus()}} and \code{\link[=mo_gramstain]{mo_gramstain()}}.

This is \strong{the fastest way} to have your organisation (or analysis) specific codes picked up and translated by this package.
}
\details{
The reference file can be a text file seperated with commas (CSV) or tabs or pipes, an Excel file (either 'xls' or 'xlsx' format) or an R object file (extension '.rds'). To use an Excel file, you need to have the \code{readxl} package installed.

\code{\link[=set_mo_source]{set_mo_source()}} will check the file for validity: it must be a \code{\link{data.frame}}, must have a column named \code{"mo"} which contains values from \code{\link[=microorganisms]{microorganisms$mo}} and must have a reference column with your own defined values. If all tests pass, \code{\link[=set_mo_source]{set_mo_source()}} will read the file into R and export it to \code{"~/.mo_source.rds"}. This compressed data file will then be used at default for MO determination (function \code{\link[=as.mo]{as.mo()}} and consequently all \verb{mo_*} functions like \code{\link[=mo_genus]{mo_genus()}} and \code{\link[=mo_gramstain]{mo_gramstain()}}). The location of the original file will be saved as option with \code{options(mo_source = path)}. Its timestamp will be saved with \code{options(mo_source_datetime = ...)}.

\code{\link[=get_mo_source]{get_mo_source()}} will return the data set by reading \code{"~/.mo_source.rds"} with \code{\link[=readRDS]{readRDS()}}. If the original file has changed (the file defined with \code{path}), it will call \code{\link[=set_mo_source]{set_mo_source()}} to update the data file automatically.

Reading an Excel file (\code{.xlsx}) with only one row has a size of 8-9 kB. The compressed file created with \code{\link[=set_mo_source]{set_mo_source()}} will then have a size of 0.1 kB and can be read by \code{\link[=get_mo_source]{get_mo_source()}} in only a couple of microseconds (millionths of a second).
}
\section{How to setup}{


Imagine this data on a sheet of an Excel file (mo codes were looked up in the \link{microorganisms} data set). The first column contains the organisation specific codes, the second column contains an MO code from this package:\preformatted{  |         A          |       B      |
--|--------------------|--------------|
1 | Organisation XYZ   | mo           |
2 | lab_mo_ecoli       | B_ESCHR_COLI |
3 | lab_mo_kpneumoniae | B_KLBSL_PNMN |
4 |                    |              |
}

We save it as \code{"home/me/ourcodes.xlsx"}. Now we have to set it as a source:\preformatted{set_mo_source("home/me/ourcodes.xlsx")
#> NOTE: Created mo_source file '~/.mo_source.rds' from 'home/me/ourcodes.xlsx'
#>       (columns "Organisation XYZ" and "mo")
}

It has now created a file \code{"~/.mo_source.rds"} with the contents of our Excel file. Only the first column with foreign values and the 'mo' column will be kept when creating the RDS file.

And now we can use it in our functions:\preformatted{as.mo("lab_mo_ecoli")
#> [1] B_ESCHR_COLI

mo_genus("lab_mo_kpneumoniae")
#> [1] "Klebsiella"

# other input values still work too
as.mo(c("Escherichia coli", "E. coli", "lab_mo_ecoli"))
#> [1] B_ESCHR_COLI B_ESCHR_COLI B_ESCHR_COLI
}

If we edit the Excel file by, let's say, adding row 4 like this:\preformatted{  |         A          |       B      |
--|--------------------|--------------|
1 | Organisation XYZ   | mo           |
2 | lab_mo_ecoli       | B_ESCHR_COLI |
3 | lab_mo_kpneumoniae | B_KLBSL_PNMN |
4 | lab_Staph_aureus   | B_STPHY_AURS |
5 |                    |              |
}

...any new usage of an MO function in this package will update your data file:\preformatted{as.mo("lab_mo_ecoli")
#> NOTE: Updated mo_source file '~/.mo_source.rds' from 'home/me/ourcodes.xlsx'
#>       (columns "Organisation XYZ" and "mo")
#> [1] B_ESCHR_COLI

mo_genus("lab_Staph_aureus")
#> [1] "Staphylococcus"
}

To delete the reference data file, just use \code{""}, \code{NULL} or \code{FALSE} as input for \code{\link[=set_mo_source]{set_mo_source()}}:\preformatted{set_mo_source(NULL)
# Removed mo_source file '~/.mo_source.rds'.
}

If the original Excel file is moved or deleted, the mo_source file will be removed upon the next use of \code{\link[=as.mo]{as.mo()}}. If the mo_source file is manually deleted (i.e. without using \code{\link[=set_mo_source]{set_mo_source()}}), the references to the mo_source file will be removed upon the next use of \code{\link[=as.mo]{as.mo()}}.
}

\section{Stable lifecycle}{

\if{html}{\figure{lifecycle_stable.svg}{options: style=margin-bottom:5px} \cr}
The \link[=lifecycle]{lifecycle} of this function is \strong{stable}. In a stable function, major changes are unlikely. This means that the unlying code will generally evolve by adding new arguments; removing arguments or changing the meaning of existing arguments will be avoided.

If the unlying code needs breaking changes, they will occur gradually. For example, a parameter will be deprecated and first continue to work, but will emit an message informing you of the change. Next, typically after at least one newly released version on CRAN, the message will be transformed to an error.
}

\section{Read more on our website!}{

On our website \url{https://msberends.github.io/AMR} you can find \href{https://msberends.github.io/AMR/articles/AMR.html}{a comprehensive tutorial} about how to conduct AMR analysis, the \href{https://msberends.github.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.github.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}. As we would like to better understand the backgrounds and needs of our users, please \href{https://msberends.github.io/AMR/survey.html}{participate in our survey}!
}

