% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils-voxel.R
\docType{methods}
\name{toRaster}
\alias{toRaster}
\title{Voxel layer to raster}
\usage{
toRaster(vxsp, vx)
}
\arguments{
\item{vxsp}{a \code{\link{VoxelSpace-class}} object.}

\item{vx}{a voxel space horizontal slice. A data.table with \verb{i, j} columns and
least one additional variable, the value of the raster layer. Every column beside i and j will be converted into a raster layer.}
}
\value{
A \link[terra:SpatRaster-class]{terra::SpatRaster} object.
}
\description{
Converts a voxel space (i, j) layer into a \link[terra:SpatRaster-class]{terra::SpatRaster} object.
}
\examples{
\dontrun{
vxsp <- readVoxelSpace(system.file("extdata", "tls_sample.vox", package = "AMAPVox"))
library(terra)

# CHM, DEM and PAI as raster
plot(toRaster(vxsp, merge(canopyHeight(vxsp), groundElevation(vxsp), all = T)))

# PAI
vxsp <- plantAreaDensity(vxsp)
pai <- plantAreaIndex(vxsp, type = "xy", pattern.pad = "pad_transmittance")
plot(toRaster(vxsp, pai))

# sampling intensity at 2 meters
plot(toRaster(vxsp, vxsp@data[ground_distance == 2.25, .(i, j, nbSampling)]))
}

}
