% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{theta_est_l2_dqt_fixedAB}
\alias{theta_est_l2_dqt_fixedAB}
\title{Minimize l2 loss for Dqt with fixed A(q) and B}
\usage{
theta_est_l2_dqt_fixedAB(
  param,
  q,
  index_q,
  Dqt,
  A_est_q,
  B_est,
  d_input,
  model_name,
  msd_fn = NA,
  msd_grad_fn = NA
)
}
\arguments{
\item{param}{a vector of natural logarithm of parameters}

\item{q}{wave vector in unit of um^-1}

\item{index_q}{selected index of wave number}

\item{Dqt}{observed dynamic image structure function. See 'Details'.}

\item{A_est_q}{estimated value of A(q). This parameter is determined by
the properties of the imaged material and imaging optics. See 'References'.}

\item{B_est}{estimated value of B. This parameter is determined by the noise
in the system. See 'References'.}

\item{d_input}{sequence of lag times}

\item{model_name}{model name for the fitted model, options from ('BM','OU',
'FBM',OU+FBM','user_defined')}

\item{msd_fn}{msd_fn user defined mean squared displacement structure (MSD), a
function of \code{param} parameters and \code{d_input} lag times}

\item{msd_grad_fn}{user defined MSD gradient structure,  a function of
\code{param} and \code{d_input}}
}
\value{
A list of estimated parameters and MSD from minimizing the l2 loss
function.
}
\description{
Minimize l2 loss function for dynamic image structure function(Dqt) with
fixed A(q) and B, and return estimated parameters and mean squared
displacement(MSD).
}
\details{
Dynamic image structure function(Dqt) can be obtained from ensemble average
of absolute values squared of Four transformed intensity difference:
\deqn{D(q,\Delta t) = \langle |\Delta \hat{I}(q,t,\Delta t)|^2\rangle}{\%D(q,\Delta t) = \langle |\Delta \hat{I}(q,t,\Delta t)|^2\rangle}
See 'References'.
}
\references{
Gu, M., He, Y., Liu, X., & Luo, Y. (2023). Ab initio uncertainty
quantification in scattering analysis of microscopy.
arXiv preprint arXiv:2309.02468.

Gu, M., Luo, Y., He, Y., Helgeson, M. E., & Valentine, M. T. (2021).
Uncertainty quantification and estimation in differential dynamic microscopy.
Physical Review E, 104(3), 034610.

Cerbino, R., & Trappe, V. (2008). Differential dynamic microscopy: probing
wave vector dependent dynamics with a microscope. Physical review letters,
100(18), 188102.
}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
