% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{intensity_format_transform}
\alias{intensity_format_transform}
\title{Transform intensity profile into SS_T matrix}
\usage{
intensity_format_transform(intensity, intensity_str)
}
\arguments{
\item{intensity}{intensity profile, array or matrix}

\item{intensity_str}{structure of the original intensity
profile, options from ('SST_array','S_ST_mat','T_SS_mat')}
}
\value{
A matrix of transformed intensity profile.
}
\description{
Transform intensity profile with different formats, ('SST_array',S_ST_mat',
'T_SS_mat'), space by space by time array,space by (space by time) matrix,
or time by (space by space) matrix, into SS_T matrix. In addition, crop
each frame into a square image with odd frame size.
}
\examples{
library(AIUQ)
# -------------------------------------------------
# Example 1: Transform T_SS_mat into SS_T_mat, each
#             frame contains number 1-9
# -------------------------------------------------
(m <- matrix(rep(1:9,4),4,9,byrow=TRUE))
intensity_format_transform(m,intensity_str="T_SS_mat")

# -------------------------------------------------
# Example 2: Transform SST_array into SS_T_mat, each
#             frame contains number 1-9
# -------------------------------------------------
(m <- array(rep(1:9,4),dim=c(3,3,4)))
intensity_format_transform(m,intensity_str="SST_array")

}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
