% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{FFT2D}
\alias{FFT2D}
\title{2D Fourier transformation and calculate wave number}
\usage{
FFT2D(intensity, pxsz, mindt)
}
\arguments{
\item{intensity}{intensity profile, SS_T matrix}

\item{pxsz}{size of one pixel in unit of micron}

\item{mindt}{minimum lag time}
}
\value{
A list object containing transformed intensity profile in reciprocal
space and corresponding parameters.
}
\description{
Perform 2D fast Fourier transformation on SS_T matrix, record frame size for
each frame, total number of frames, and sequence of lag times. Calculate and
record circular wave number for complete q ring.
}
\references{
Gu, M., He, Y., Liu, X., & Luo, Y. (2023). Ab initio uncertainty
quantification in scattering analysis of microscopy.
arXiv preprint arXiv:2309.02468.

Gu, M., Luo, Y., He, Y., Helgeson, M. E., & Valentine, M. T. (2021).
Uncertainty quantification and estimation in differential dynamic microscopy.
Physical Review E, 104(3), 034610.

Cerbino, R., & Trappe, V. (2008). Differential dynamic microscopy: probing
wave vector dependent dynamics with a microscope. Physical review letters,
100(18), 188102.
}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
