% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regsel_f.R
\name{regsel_f}
\alias{regsel_f}
\title{Regressors selection}
\usage{
regsel_f(
  model,
  pval = 0.3,
  metric = "adjr" & "aic",
  progress = FALSE,
  details = FALSE,
  ...
)
}
\arguments{
\item{model}{is a linear regression model}

\item{pval}{p value; variables with p value less than \code{pval} will
enter into the model}

\item{metric}{statistical metrics used to estimate the best model}

\item{progress}{Logical; if TRUE, will display variable selection progress.}

\item{details}{Logical; if \code{TRUE}, will print the regression result at
each step.}

\item{...}{other arguments}
}
\description{
The function allows to choose regressors based on multiple criteria as {AIC}, {RMSE} etc
}
\examples{
data(macroKZ)
model <- lm(real_gdp ~ imp + exp + poil + eurkzt + tonia_rate, data = macroKZ)
regsel_f(model)
}
\references{
Hebbali, Aravind. Published 2020-02-10. olssr package
}
