% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bp.R
\name{bp}
\alias{bp}
\title{Breusch-Pagan test}
\usage{
bp(model, varformula = NULL, studentize = TRUE, data = list())
}
\arguments{
\item{model}{is a (generalized)linear regression model}

\item{varformula}{a formula describing only the potential explanatory variables for the variance (no dependent variable needed). By default the same explanatory variables are taken as in the main regression model.}

\item{studentize}{logical. If set to TRUE Koenker's studentized version of the test statistic will be used.}

\item{data}{an optional data frame containing the variables in the model}
}
\description{
Breusch-Pagan test is used to test against heteroskedasticity of a time-series
}
\examples{
model <- lm(real_gdp ~ imp + exp + poil + eurkzt + tonia_rate, data = macroKZ)
bp(model)
}
\references{
Torsten, H., Zeileis, A., Farebrother, Richard W., Cummins, C., Millo, G., Mitchell, D., lmtest package
Wang, B., 2014, bstats package
}
