% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AFMImage.R
\name{sampleAFMImage}
\alias{sampleAFMImage}
\title{Get a sample of an AFM image.}
\usage{
sampleAFMImage(AFMImage, percentage)
}
\arguments{
\item{AFMImage}{an \code{\link{AFMImage}} from Atomic Force Microscopy}

\item{percentage}{percentage of heights to keep}
}
\value{
a sample of an \code{\link{AFMImage}}
}
\description{
Random selection of heights to keep in an \code{\link{AFMImage}}.
This function can be used to calculate quickly an approximated variogram of a large image.
}
\details{
\code{sampleAFMImage} returns a sample of the AFMImage to boost calculation time of variogram
}
\examples{
\dontrun{
library(AFM)
library(ggplot2)

data(AFMImageOfAluminiumInterface)
anAFMImageSample<-sampleAFMImage(AFMImageOfAluminiumInterface,15)
variogramAnalysis<-AFMImageVariogramAnalysis(sampleFitPercentage=3.43)
avario<-AFM::calculateOmnidirectionalVariogram(AFMImage= anAFMImageSample,
                                               AFMImageVariogramAnalysis= variogramAnalysis)
dist<-gamma<-NULL
p1 <- ggplot(avario, aes(x=dist, y=gamma))
p1 <- p1 + geom_point()
p1 <- p1 + geom_line()
p1 <- p1 + ylab("semivariance")
p1 <- p1 + xlab("distance (nm)")
p1 <- p1 + ggtitle("Approximation of variogram thanks to sampling")
p1
}
}
\author{
M.Beauvais
}

