% File src/library/base/man/paste.Rd
% Part of the R package, http://www.R-project.org
% Copyright 1995-2008 R Core Development Team
% Distributed under GPL 2 or later

\name{paste}
\title{Concatenate Strings}
\concept{combine strings}
\usage{
paste(\dots, sep = " ", collapse = NULL)
}
\alias{paste}
\arguments{
  \item{\dots}{one or more \R objects, to be converted to character vectors.}
  \item{sep}{a character string to separate the terms.  Not
    \code{\link{NA_character_}}.}
  \item{collapse}{an optional character string to separate the results.  Not
    \code{\link{NA_character_}}.}
}
\description{
  Concatenate vectors after converting to character.
}
\details{
  \code{paste} converts its arguments (\emph{via}
  \code{\link{as.character}}) to character strings, and concatenates
  them (separating them by the string given by \code{sep}).  If the
  arguments are vectors, they are concatenated term-by-term to give a
  character vector result.  Vector arguments are recycled as needed,
  with zero-length arguments being recycled to \code{""}.

  Note that \code{paste()} coerces \code{\link{NA_character_}}, the
  character missing value, to \code{"NA"} which may seem
  undesirable, e.g., when pasting two character vectors, or very
  desirable, e.g. in \code{paste("the value of p is ", p)}.

  If a value is specified for \code{collapse}, the values in the result
  are then concatenated into a single string, with the elements being
  separated by the value of \code{collapse}.

  Character inputs with embedded nul bytes will be truncated at the first nul.
}
\value{
  A character vector of the concatenated values.  This will be of length
  zero if all the objects are, unless \code{collapse} is non-NULL in
  which case it is a single empty string.
  
  If any input into an element of the result is in UTF-8, that element
  will be in UTF-8, otherwise in the current encoding in which case the
  encoding of an element of the element is declared if the current
  locale is either Latin-1 or UTF-8, at least one of the corresponding
  inputs (including separators) had a declared encoding and all inputs
  were either ASCII or declared.
}
\references{
  Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988)
  \emph{The New S Language}.
  Wadsworth \& Brooks/Cole.
}
\seealso{
  String manipulation with
  \code{\link{as.character}}, \code{\link{substr}}, \code{\link{nchar}},
  \code{\link{strsplit}}; further, \code{\link{cat}} which concatenates and
  writes to a file, and \code{\link{sprintf}} for C like string
  construction.

  \sQuote{\link{plotmath}} for the use of \code{paste} in plot annotation.
}
\examples{
paste(1:12) # same as as.character(1:12)
paste("A", 1:6, sep = "")
paste("Today is", date())
}
\keyword{character}
