\name{language-class}
\docType{class}
\alias{language-class}
\alias{(-class}
\alias{<--class}
\alias{call-class}
\alias{for-class}
\alias{if-class}
\alias{repeat-class}
\alias{while-class}
\alias{name-class}
\alias{{-class}

\title{Classes to Represent Unevaluated Language Objects }
\description{  The virtual class \code{"language"} and the specific
  classes that extend it represent unevaluated objects, as produced for
  example by the parser or by functions such as \code{\link{quote}}.
}
\usage{
### each of these classes corresponds to an unevaluated object
### in the S language.  The class name can appear in method signatures,
### and in a few other contexts (such as some calls to as()).

"("
"<-"
"call"
"for"
"if"
"repeat"
"while"
"name"
"\{"

### Each of the classes above extends the virtual class

"language"



}
\section{Objects from the Class}{
  \code{"language"} is a virtual class; no objects may be created from
  it.

Objects from the other classes can be generated by a call to
\code{new(Class, ...)}, where \code{Class} is the quoted class name, and
the \dots arguments are either empty or a \emph{single} object that is
from this class (or an extension).}


\section{Methods}{
  \describe{
    \item{coerce}{\code{signature(from = "ANY", to = "call")}.  A method
      exists for \code{as(object, "call")}, calling \code{as.call()}. }
  }

}
\keyword{classes}
