







use crate::imp_prelude::*;




impl<'a, A, D> CowArray<'a, A, D>
where D: Dimension
{
    
    pub fn is_view(&self) -> bool
    {
        self.data.is_view()
    }

    
    pub fn is_owned(&self) -> bool
    {
        self.data.is_owned()
    }
}

impl<'a, A, D> From<ArrayView<'a, A, D>> for CowArray<'a, A, D>
where D: Dimension
{
    fn from(view: ArrayView<'a, A, D>) -> CowArray<'a, A, D>
    {
        
        unsafe { ArrayBase::from_data_ptr(CowRepr::View(view.data), view.ptr).with_strides_dim(view.strides, view.dim) }
    }
}

impl<'a, A, D> From<Array<A, D>> for CowArray<'a, A, D>
where D: Dimension
{
    fn from(array: Array<A, D>) -> CowArray<'a, A, D>
    {
        
        unsafe {
            ArrayBase::from_data_ptr(CowRepr::Owned(array.data), array.ptr).with_strides_dim(array.strides, array.dim)
        }
    }
}

impl<'a, A, Slice: ?Sized> From<&'a Slice> for CowArray<'a, A, Ix1>
where Slice: AsRef<[A]>
{
    
    
    
    
    
    
    
    
    
    
    
    fn from(slice: &'a Slice) -> Self
    {
        Self::from(ArrayView1::from(slice))
    }
}

impl<'a, A, S, D> From<&'a ArrayBase<S, D>> for CowArray<'a, A, D>
where
    S: Data<Elem = A>,
    D: Dimension,
{
    
    fn from(array: &'a ArrayBase<S, D>) -> Self
    {
        Self::from(array.view())
    }
}
