% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json.R
\name{write_json_raw}
\alias{write_json_raw}
\title{Convert R object to a raw vector of JSON data}
\usage{
write_json_raw(x, opts = list(), ...)
}
\arguments{
\item{x}{the object to be encoded}

\item{opts}{Named list of serialization options. Usually created by \code{\link[=opts_write_json]{opts_write_json()}}}

\item{...}{Other named options can be used to override any options in \code{opts}.
The valid named options are identical to arguments to \code{\link[=opts_write_json]{opts_write_json()}}}
}
\value{
Raw vector containing the JSON
}
\description{
Convert R object to a raw vector of JSON data
}
\examples{
js <- write_json_raw(head(iris, 3))
js
read_json_raw(js)
}
\seealso{
Other JSON Serializer: 
\code{\link{write_json_file}()},
\code{\link{write_json_str}()},
\code{\link{write_ndjson_file}()},
\code{\link{write_ndjson_raw}()},
\code{\link{write_ndjson_str}()}
}
\concept{JSON Serializer}
