% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_yml.R
\name{use_yml_defaults}
\alias{use_yml_defaults}
\alias{use_rmd_defaults}
\alias{get_yml_defaults}
\alias{get_rmd_defaults}
\title{Set up default YAML}
\usage{
use_yml_defaults(.yml)

use_rmd_defaults(x)

get_yml_defaults()

get_rmd_defaults()
}
\arguments{
\item{.yml}{a \code{yml} object created by \code{yml()}, \code{as_yml()}, or returned by
a \verb{yml_*()} function}

\item{x}{a character vector to use as the body text in \code{\link[=use_rmarkdown]{use_rmarkdown()}}.}
}
\description{
\code{use_yml_defaults()} takes a \code{yml} object and places code on the clipboard
that will save the resulting YAML as the default for \code{yml()}. The code that
is placed on the clipboard is raw YAML passed to \code{ymlthis.default_yml} via
\code{options()}. Saving this code to your \code{.Rprofile} (see
\code{\link[usethis:edit]{usethis::edit_r_profile()}})) will allow \code{\link[=yml]{yml()}} or
\code{\link[=get_yml_defaults]{get_yml_defaults()}} to return the saved YAML. \code{use_rmd_defaults()} does
the same for \code{ymlthis.rmd_body}, which is used in \code{\link[=use_rmarkdown]{use_rmarkdown()}} as the
body text of the created R Markdown file.
}
\seealso{
\code{\link[=yml]{yml()}} \code{\link[=get_yml_defaults]{get_yml_defaults()}}

Other yml: 
\code{\link{asis_yaml_output}()},
\code{\link{bib2yml}()},
\code{\link{draw_yml_tree}()},
\code{\link{has_field}()},
\code{\link{read_json}()},
\code{\link{use_yml}()},
\code{\link{use_yml_file}()},
\code{\link{yml_author}()},
\code{\link{yml_blogdown_opts}()},
\code{\link{yml_bookdown_opts}()},
\code{\link{yml_citations}()},
\code{\link{yml_clean}()},
\code{\link{yml_distill_opts}()},
\code{\link{yml_latex_opts}()},
\code{\link{yml_output}()},
\code{\link{yml_pagedown_opts}()},
\code{\link{yml_params}()},
\code{\link{yml_pkgdown}()},
\code{\link{yml_reference}()},
\code{\link{yml_replace}()},
\code{\link{yml_resource_files}()},
\code{\link{yml_rsconnect_email}()},
\code{\link{yml_rticles_opts}()},
\code{\link{yml_runtime}()},
\code{\link{yml_site_opts}()},
\code{\link{yml_toc}()},
\code{\link{yml_vignette}()}
}
\concept{yml}
