% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_tickers}
\alias{search_tickers}
\title{Search for ticker symbols, companies, and news from Yahoo Finance}
\usage{
search_tickers(
  query,
  limit = 10,
  quotes_only = TRUE,
  fuzzy_query = FALSE,
  lists_count = 0,
  enable_research = FALSE,
  proxy = NULL,
  output = c("tibble", "response", "request", "all")
)
}
\arguments{
\item{query}{Search query string}

\item{limit}{Maximum number of results to return (default 10)}

\item{quotes_only}{Return only quotes/tickers, not news (default TRUE)}

\item{fuzzy_query}{Enable fuzzy search for typos (default FALSE)}

\item{lists_count}{Number of lists to retrieve (default 0)}

\item{enable_research}{Include research reports (default FALSE)}

\item{proxy}{Optional proxy settings}

\item{output}{Object to return. Can be "tibble", "response", "request", or "all" (default "tibble")}
}
\value{
Depending on output parameter:
\itemize{
\item "tibble": quotes data (or a list with quotes and news if quotes_only is FALSE)
\item "response": raw response from the API
\item "request": the request object
\item "all": a named list containing all results: quotes, news, lists, research, and raw response
}
}
\description{
This function allows you to search for ticker symbols, companies, ETFs, etc.
using the Yahoo Finance search API. It can also return related news articles.
The search functionality is particularly useful for discovering ticker symbols
when you only know the company name or part of it.
}
\section{Rate Limiting}{

Yahoo Finance does not provide official API documentation or rate limits. Based on community
observations, search queries may be more heavily rate-limited than other endpoints.
To avoid rate limiting:
\itemize{
\item Limit the frequency of search requests
\item Cache search results when possible
\item Consider adding delays between requests (e.g., using \code{Sys.sleep()})
\item Use more specific search queries to reduce the number of needed requests
}
}

\examples{
\dontrun{
# Search for Apple
apple_results <- search_tickers("Apple")

# Search for tech companies with more results
tech_results <- search_tickers("tech", limit = 20)

# Get both quotes and news articles
apple_with_news <- search_tickers("Apple", quotes_only = FALSE)

# Get all data including lists and research reports
all_apple_data <- search_tickers(
  "Apple",
  quotes_only = FALSE,
  lists_count = 5,
  enable_research = TRUE,
  output = "all"
)
}
}
