% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tickers.R
\name{get_tickers_income_statement}
\alias{get_tickers_income_statement}
\title{Get income statement for multiple tickers}
\usage{
get_tickers_income_statement(
  tickers_obj,
  freq = c("annual", "quarterly"),
  start = NULL,
  end = NULL,
  income_keys = NULL,
  pretty = TRUE,
  wide = TRUE,
  proxy = NULL,
  output = c("tibble", "response", "request")
)
}
\arguments{
\item{tickers_obj}{A tickers object created with get_tickers()}

\item{freq}{Frequency of data: "annual" or "quarterly" (default "annual")}

\item{start}{Start timestamp as date, datetime, or string (default EOY 2016)}

\item{end}{End timestamp as date, datetime, or string (default current timestamp)}

\item{income_keys}{Vector of specific income statement keys to include (default all)
See \code{valid_income_keys} for available options.}

\item{pretty}{Format column names to be more readable (default TRUE)}

\item{wide}{Return data in wide format with dates as columns (default TRUE).
If FALSE, returns data in long format with a date column.}

\item{proxy}{Optional proxy settings for the request}

\item{output}{Object to return. Can be "tibble", "response", or "request" (default "tibble")}
}
\value{
A list of tibbles with income statement data for each ticker
}
\description{
Retrieves income statement data from Yahoo Finance for multiple specified ticker symbols.
Income statements show a company's revenues, expenses, and profits over a specific period.
}
\details{
See \code{get_income_statement} for more details on the income statement.
}
\examples{
\dontrun{
tech_tickers <- get_tickers(c("AAPL", "MSFT", "GOOG"))
tech_income <- get_tickers_income_statement(tech_tickers)
}
}
