% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/financials.R
\name{get_balance_sheet}
\alias{get_balance_sheet}
\title{Get balance sheet for a ticker}
\usage{
get_balance_sheet(
  ticker,
  freq = c("annual", "quarterly"),
  start = NULL,
  end = NULL,
  balance_keys = NULL,
  pretty = TRUE,
  wide = TRUE,
  proxy = NULL,
  output = c("tibble", "response", "request")
)
}
\arguments{
\item{ticker}{A ticker object created with \code{get_tickers()} or a ticker symbol string}

\item{freq}{Frequency of data: "annual" or "quarterly" (default "annual")}

\item{start}{Start timestamp as date, datetime, or string (default EOY 2016)}

\item{end}{End timestamp as date, datetime, or string (default current timestamp)}

\item{balance_keys}{Vector of specific balance sheet keys to include (default all)
See \code{valid_balance_keys} for available options.}

\item{pretty}{Format column names to be more readable (default TRUE)}

\item{wide}{Return data in wide format with dates as columns (default TRUE).
If FALSE, returns data in long format with a date column.}

\item{proxy}{Optional proxy settings for the request}

\item{output}{Object to return. Can be "tibble", "response", or "request" (default "tibble")}
}
\value{
Either a tibble with balance sheet data, an httr2 response object, or an httr2 request object
depending on the value of the output argument.
}
\description{
Retrieves balance sheet data from Yahoo Finance for a specified ticker symbol.
Balance sheets show a company's assets, liabilities, and shareholders' equity
at a specific point in time.
}
\section{Available Balance Keys}{


Examples:
\itemize{
\item TotalAssets
\item TotalCapitalization
\item CurrentAssets
}

See \code{valid_balance_keys} for a full list of available balance keys.
}

\examples{
\dontrun{
apple <- get_tickers("AAPL")

# Get annual balance sheet
balance_sheet <- get_balance_sheet(apple)

# Get quarterly balance sheet
quarterly_balance <- get_balance_sheet(apple, freq = "quarterly")

# Get specific balance sheet items
assets_liabilities <- get_balance_sheet(apple,
  balance_keys = c("TotalAssets", "TotalLiabilities")
)

# Get data for a specific time period
balance_2020_2022 <- get_balance_sheet(apple,
  start = "2020-01-01",
  end = "2022-12-31"
)
}
}
